/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.relics;

import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.PowerTip;
import com.megacrit.cardcrawl.relics.AbstractRelic;

public class Ectoplasm
extends AbstractRelic {
    public static final String ID = "Ectoplasm";

    public Ectoplasm() {
        this(null);
    }

    public Ectoplasm(AbstractPlayer.PlayerClass c) {
        super(ID, "ectoplasm.png", AbstractRelic.RelicTier.BOSS, AbstractRelic.LandingSound.FLAT);
    }

    @Override
    public String getUpdatedDescription() {
        if (AbstractDungeon.player != null) {
            return this.setDescription(AbstractDungeon.player.chosenClass);
        }
        return this.setDescription(null);
    }

    private String setDescription(AbstractPlayer.PlayerClass c) {
        if (c == null) {
            return this.DESCRIPTIONS[1] + this.DESCRIPTIONS[0];
        }
        switch (c) {
            case IRONCLAD: {
                return this.DESCRIPTIONS[1] + this.DESCRIPTIONS[0];
            }
            case THE_SILENT: {
                return this.DESCRIPTIONS[2] + this.DESCRIPTIONS[0];
            }
            case CROWBOT: {
                return this.DESCRIPTIONS[3] + this.DESCRIPTIONS[0];
            }
        }
        return this.DESCRIPTIONS[1] + this.DESCRIPTIONS[0];
    }

    @Override
    public void updateDescription(AbstractPlayer.PlayerClass c) {
        this.description = this.setDescription(c);
        this.tips.clear();
        this.tips.add(new PowerTip(this.name, this.description));
        this.initializeTips();
    }

    @Override
    public void onEquip() {
        ++AbstractDungeon.player.energy.energyMaster;
    }

    @Override
    public void onUnequip() {
        --AbstractDungeon.player.energy.energyMaster;
    }

    @Override
    public AbstractRelic makeCopy() {
        return new Ectoplasm(AbstractDungeon.player.chosenClass);
    }

    @Override
    public AbstractRelic makeCopy(AbstractPlayer.PlayerClass chosenClass) {
        return new Ectoplasm(chosenClass);
    }
}

